library(data.table)
library(ggplot2)
library(ggthemes)

ests <- fread('democ_ests_neur_ips.csv')
#ests <- ests[ests$samples == 'Two'| ests$institutions == 'polyarchy',]
ests$Model <- ifelse(ests$institutions == 'all', 'All Democratic 
Institutions', 
'Democracy 
Index')
#ests$lower[ests$institutions == 'polyarchy'] <- NA
#ests$upper[ests$institutions == 'polyarchy'] <- NA
ests$q <- factor(ests$q)

pdf('civ_war_results_neurips.pdf', height = 4, width=7)
ggplot(ests[ests$q != .05,], aes(x=q, y=est, ymin=lower, ymax=upper, color=Model)) + geom_point(position=position_dodge(width=.5)) +
  geom_errorbar(position=position_dodge(width=.5)) + theme_few() + geom_hline(yintercept=0, alpha=.25, linetype=2) 
#  ylab(expression(widehat("MCSE")['q'])) + xlab('q')+ theme(legend.position="bottom") + facet_wrap(~Model)
dev.off()

